﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager.EFR;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class Patients : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PanelSelectPatient.Visible = true;

            LoadPreviousSearch();
        }

        if (!CurrentUser.IsInRole(EFRSharedConstant.EfrUserRoleTefscCoordinator)
            && !CurrentUser.IsInRole(EFRSharedConstant.EfrUserRoleProvider)
            && !CurrentUser.IsInRole(EFRSharedConstant.EfrUserRoleNurse))
        {
            GridViewEFRPatients.Columns[8].Visible = false;
        }
    }

    private void LoadPreviousSearch()
    {
        bool previousSearchValid = false;

        string searchAll = SessionItemValue.Get(Session["Patient_Search_All"]);
        if (!string.IsNullOrEmpty(searchAll))
            previousSearchValid = true;
        else
        {
            string firstNameSearch = SessionItemValue.Get(Session["Patient_Search_First_Name"]);
            if (!string.IsNullOrEmpty(firstNameSearch))
            {
                TextBoxPatientFirstNameSearch.Text = firstNameSearch;
                previousSearchValid = true;
            }

            string lastNameSearch = SessionItemValue.Get(Session["Patient_Search_Last_Name"]);
            if (!string.IsNullOrEmpty(lastNameSearch))
            {
                TextBoxPatientLastNameSearch.Text = lastNameSearch;
                previousSearchValid = true;
            }

            string icn = SessionItemValue.Get(Session["Patient_Search_Icn"]);
            if (!string.IsNullOrEmpty(icn))
            {
                TextBoxPatientICNSearch.Text = icn;
                previousSearchValid = true;
            }
        }

        if (previousSearchValid)
            Search();
    }

    protected void ButtonSearchPatient_Click(object sender, EventArgs e)
    {
        Search();
    }

    private void Search()
    {
        if (HiddenFieldEfrPatients.Value == "false" && IsCurrentUserSuperUser())
        {
            GridViewEFRPatients.Visible = false;

            GridViewNonEfrPatients.PageIndex = 0;
            GridViewNonEfrPatients.Visible = true;
            GridViewNonEfrPatients.DataBind();
        }
        else
        {
            GridViewNonEfrPatients.Visible = false;

            GridViewEFRPatients.PageIndex = 0;
            GridViewEFRPatients.Visible = true;
            GridViewEFRPatients.DataBind();
        }

        if (GridViewEFRPatients.Visible && GridViewEFRPatients.Rows.Count == 0
            && IsCurrentUserSuperUser() && HiddenFieldEfrPatients.Value == "true")
        {
            GridViewEFRPatients.Visible = false;

            string message = "No EFR patients matching your search criteria were found.  Would you like to search the Registries database?";
            ClientScript.RegisterStartupScript(typeof(Page), "Popup", "PopUpMessage('" + message + "');", true);
        }

        var master = Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        if (GridViewNonEfrPatients.Visible)
        {
            HiddenFieldEfrPatients.Value = "true";
        }

        SaveCurrentSearchFields();
    }

    private void SaveCurrentSearchFields()
    {
        if (SearchAllPatients())
            Session["Patient_Search_All"] = SessionItemFactory.Create("True");
        else
        {
            Session.Remove("Patient_Search_All");

            if (!string.IsNullOrEmpty(TextBoxPatientFirstNameSearch.Text))
                Session["Patient_Search_First_Name"] = SessionItemFactory.Create(TextBoxPatientFirstNameSearch.Text);
            else
                Session.Remove("Patient_Search_First_Name");

            if (!string.IsNullOrEmpty(TextBoxPatientLastNameSearch.Text))
                Session["Patient_Search_Last_Name"] = SessionItemFactory.Create(TextBoxPatientLastNameSearch.Text);
            else
                Session.Remove("Patient_Search_Last_Name");

            if (!string.IsNullOrEmpty(TextBoxPatientICNSearch.Text))
                Session["Patient_Search_Icn"] = SessionItemFactory.Create(TextBoxPatientICNSearch.Text);
            else
                Session.Remove("Patient_Search_Icn");
        }
    }

    private bool SearchAllPatients()
    {
        return string.IsNullOrEmpty(TextBoxPatientSSNSearch.Text)
            && string.IsNullOrEmpty(TextBoxPatientFirstNameSearch.Text)
            && string.IsNullOrEmpty(TextBoxPatientLastNameSearch.Text)
            && string.IsNullOrEmpty(TextBoxPatientICNSearch.Text);
    }

    public void Patients_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRPatients.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
            Response.Redirect("Patient.aspx?patientId={0}", id);
        }
        else if (e.CommandName == "Workflows")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRPatients.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
            Response.Redirect("PatientWorkflows.aspx?patientId={0}", id);
        }
        else if (e.CommandName == "Diagnostics")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRPatients.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
            Response.Redirect("PatientRelatedDiagnoses.aspx?patientId={0}", id);
        }
        else if (e.CommandName == "LabTests")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRPatients.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
            Response.Redirect("PatientRelatedLabTests.aspx?patientId={0}", id);
        }
        else if (e.CommandName == "Images")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRPatients.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRPatients.SelectedValue);
            Response.Redirect("PatientImaging.aspx?patientId={0}", id);
        }
    }

    public void NonEfrPatients_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "AddReferral")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewNonEfrPatients.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewNonEfrPatients.SelectedValue);
            GridViewNonEfrPatients.SelectedIndex = -1;

            Response.Redirect("referral.aspx?referralId=0&patientId={0}", id);
        }
    }

    public void valBirthDate_ServerValidate(object source, ServerValidateEventArgs args)
    {

        string sLastName = TextBoxPatientLastNameSearch.Text.Trim();
        string sFirstName = TextBoxPatientFirstNameSearch.Text.Trim();
        string sSSN = TextBoxPatientSSNSearch.Text.Trim();
        string sICN = TextBoxPatientICNSearch.Text.Trim();

        if (String.IsNullOrEmpty(sLastName + sFirstName + sSSN + sICN))
        {
            var src = source as CustomValidator;
            if (src != null)
            {
                src.ErrorMessage = "* Please enter search information.";
            }
            //(source as CustomValidator).ErrorMessage = "* Please enter search information.";
            args.IsValid = false;
            return;
        }
        else
        {
            args.IsValid = true;
        }
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }
}
